// routes/index.js

const express = require('express');
const router = express.Router();

// Import controller untuk autentikasi, materi, dan latihan
const authController = require('../controllers/authController');
const materiController = require('../controllers/materiController');
const latihanController = require('../controllers/latihanController');
// Quiz dipisah ke file terpisah, jadi controller quiz tidak diimpor langsung di sini

// Import model Materi (digunakan untuk dashboard)
const Materi = require('../models/Materi');

// --- Rute Autentikasi ---
router.get('/login', authController.showLogin);
router.post('/login', authController.login);
router.get('/register', authController.showRegister);
router.post('/register', authController.register);
router.get('/logout', authController.logout);

// --- Rute Materi ---
router.get('/materi', materiController.index);
router.get('/materi/:id', materiController.detail);

// --- Rute Latihan ---
router.get('/latihan', latihanController.index);
router.get('/latihan/:id', latihanController.detail);
router.post('/latihan/:id', latihanController.submit);

// --- Rute Quiz ---
// Rute quiz sekarang didelegasikan ke file routes/quiz.js
router.use('/quiz', require('./quiz'));

// --- Rute Terminal untuk Latihan Interaktif ---
router.get('/terminal/:id', (req, res) => {
  const latihanId = req.params.id;
  res.render('pages/terminal', { title: 'Terminal Interaktif', latihanId });
});

// --- Rute Home (Dashboard) ---
router.get('/', (req, res) => {
  if (req.session && req.session.user) {
    Materi.getAll((err, results) => {
      if (err) {
        console.error(err);
        return res.render('pages/index', { 
          title: 'Dashboard', 
          user: req.session.user, 
          materi: [] 
        });
      }
      res.render('pages/index', { 
        title: 'Dashboard', 
        user: req.session.user, 
        materi: results 
      });
    });
  } else {
    res.redirect('/login');
  }
});

module.exports = router;
