// routes/quiz.js

const express = require('express');
const router = express.Router();
const quizController = require('../controllers/quizController');

// Route default untuk menampilkan daftar materi dengan quiz
router.get('/', quizController.listMateri);

// Menampilkan halaman quiz berdasarkan materiId
router.get('/:materiId', quizController.getQuiz);

// Memproses submit jawaban quiz
router.post('/:materiId', quizController.submitQuiz);

module.exports = router;
